#include <stdio.h>
#include <stdlib.h>

struct pomeraj {
    long long x, y;
    int indeks;
};

int gornja(struct pomeraj a) {
    return (a.y > 0 || (a.y == 0 && a.x > 0));
}

long long cross(struct pomeraj a, struct pomeraj b) {
    return a.x * b.y - a.y * b.x;
}

int uporedi(const void *A, const void *B) {
    struct pomeraj a = *(struct pomeraj*)A;
    struct pomeraj b = *(struct pomeraj*)B;

    int ha = gornja(a);
    int hb = gornja(b);
    if (ha != hb) return hb - ha;

    long long c = cross(a, b);
    if (c > 0) return -1;
    if (c < 0) return 1;
    return 0;
}

int main() {
    int n;
    scanf("%d", &n);

    struct pomeraj *v = malloc(n * sizeof(struct pomeraj));

    for (int i = 0; i < n; i++) {
        scanf("%lld %lld", &v[i].x, &v[i].y);
        v[i].indeks = i + 1;
    }

    qsort(v, n, sizeof(struct pomeraj), uporedi);

    struct pomeraj *w = malloc(2 * n * sizeof(struct pomeraj));
    for (int i = 0; i < n; i++) {
        w[i] = v[i];
        w[i + n] = v[i];
    }

    long long sx = 0, sy = 0;
    long long najbolja = 0;
    int najbolji_l = 0, najbolji_r = -1;

    int r = 0;
    for (int l = 0; l < n; l++) {
        while (r < l + n && cross(w[l], w[r]) >= 0) {
            sx += w[r].x;
            sy += w[r].y;
            r++;
        }

        long long dist = sx * sx + sy * sy;
        if (dist > najbolja) {
            najbolja = dist;
            najbolji_l = l;
            najbolji_r = r - 1;
        }

        sx -= w[l].x;
        sy -= w[l].y;
    }

    int k = najbolji_r - najbolji_l + 1;
    printf("%d\n", k);
    for (int i = najbolji_l; i <= najbolji_r; i++)
        printf("%d ", w[i].indeks);
    printf("\n");

    return 0;
}